#!/bin/sh

MASTER_PAGE_ADDITIONAL_ESXI_CONF_RESULT_MSG=""
MASTER_PAGE_ADDITIONAL_ESXI_CONF_RESULT_OK=0
MASTER_PAGE_ADDITIONAL_ESXI_CONF_RESULT_ERROR=1

MASTER_PAGE_ADDITIONAL_ESXI_CONF_RESULT_CODE=${MASTER_PAGE_ADDITIONAL_ESXI_CONF_RESULT_ERROR}
MASTER_PAGE_ADDITIONAL_ESXI_CONF_RESULT_ROLLING=0

master_page_additional_esxi_conf() {
		
	local menu_list="1 \"${MASTER_PAGE_ADDITIONAL_ESXI_CONF_ITEM_1}\" "
	local menu_index="1" # additinoal esxi starts with 2
	
	##################################################
	# get name_list of all clusters
	##################################################
	local name_list
	name_list=`dtascfg "$DTASCFG_XML_FILE" get "*[starts-with(name(.),"cluster_")]" name`
	
	# no cluster is found
	if [ "$?" != "0" ]; then
		name_list=
	fi
	
	debug_print $0 $LINENO "[ClusterSetting] cluster name list: $name_list"
	
	##################################################
	# composing cluster name_list to display on menu
	##################################################
	for name in $name_list
	do
		menu_index=`expr $menu_index + 1`
		menu_list="$menu_list $menu_index \"$name\""
	done
	
	##################################################
	# display menu - cluster setting
	##################################################
	tp_menu_ok_cancel \
		"${MASTER_PAGE_ADDITIONAL_ESXI_CONF_TITLE}" \
		"${MASTER_PAGE_ADDITIONAL_ESXI_CONF_TEXT}" \
		"${MASTER_PAGE_ADDITIONAL_ESXI_CONF_OK_LABEL}" \
		"${MASTER_PAGE_ADDITIONAL_ESXI_CONF_CANCEL_LABEL}" \
		"$menu_list"
		
	# if user choose CANCEL or ESC, roll back to main setting page
	if [ "${TP_MENU_OK_CANCEL_RESULT_CODE}" == "${TP_MENU_OK_CANCEL_RESULT_CANCEL}" ]; then
		MASTER_PAGE_ADDITIONAL_ESXI_CONF_RESULT_CODE=$MASTER_PAGE_ADDITIONAL_ESXI_CONF_RESULT_OK
		MASTER_PAGE_ADDITIONAL_ESXI_CONF_RESULT_ROLLING=-1
		return
	fi
	debug_print $0 $LINENO "[ClusterSetting] user choose: $TP_MENU_OK_CANCEL_RESULT_SELECT"
	
	##################################################
	# NOTE:
	#     Cluster might be removed and sc_id might be
	#     discontinued. (Ex: 2, 3, 5, 7) Thus,
	#     menu_index cannot be treated as sc_id.
	#     Query sc_id by selected_cluster_name is required.
	##################################################
	local selected_sc_id="-1"
	if [ "$TP_MENU_OK_CANCEL_RESULT_SELECT" -gt 1 ]; then

		# get selected cluster name
		local name_array=($name_list)
		local index=`expr $TP_MENU_OK_CANCEL_RESULT_SELECT - 2`
		local selected_cluster_name="${name_array[ $index ]}"
		
		# get selected cluster sc_id
		selected_sc_id=`php $CONS_BACKEND get_cluster_id_by_name $selected_cluster_name`
		if [ "$?" -ne "0" ]; then
			warning "$MASTER_PAGE_ADDITIONAL_ESXI_CONF_INTERNAL_ERROR" "MASTER_PAGE_ADDITIONAL_ESXI_CONF_FIND_SCID_ERROR"
			# stay in this page, don't go to next page
			MASTER_PAGE_ADDITIONAL_ESXI_CONF_RESULT_CODE=$MASTER_PAGE_ADDITIONAL_ESXI_CONF_RESULT_OK
			MASTER_PAGE_ADDITIONAL_ESXI_CONF_RESULT_ROLLING=0
			return
		fi
		
		# for debug
		# warning "selected_sc_id" "$selected_sc_id"
		debug_print $0 $LINENO "[ClusterSetting] selected_cluster_name: $selected_cluster_name, selected_sc_id: $selected_sc_id"
	fi

	
	##################################################
	# redirect page
	##################################################
	case "${TP_MENU_OK_CANCEL_RESULT_SELECT}" in
		1) master_page_add_esxi ;; 
		*) 	
			to_be_updated_sc_id=$selected_sc_id
			pages_roller "master_page_esxi_update" 
			;;
	esac
	
	MASTER_PAGE_ADDITIONAL_ESXI_CONF_RESULT_CODE=$MASTER_PAGE_ADDITIONAL_ESXI_CONF_RESULT_OK
	MASTER_PAGE_ADDITIONAL_ESXI_CONF_RESULT_ROLLING=0
}